-- PhysicsLab+
-- Extension of John Millard's original PhysicsLab 

-- PhysicsLab+ is built to make the amazing original PhysicsLab into a usable dependency.

-- PhysicsLab+ lets you use PhysicsLab (the class) to do all the cool stuff
-- showcased by PhysicsLab (the project), and it does a few extra cool things too,
-- like including a bonus test that was intended for the original release but didn't
-- make the cut.

-- The PhysicsLab class also helps simplify and explain some advanced concepts. 
-- For example, with the PhysicsLab class you won't need to google what REVOLUTE 
-- and PRISMATIC joints are, you can just use pointThatTwoBodiesRevolveAround(...)
-- and keepBodiesOnRailDefinedByPoints(...).

-- PhysicsLab modularizes its main abilities, which is covenient if you don't need
-- everything it can do. You can use its ShapeMaker, ShapeDrawer, JointMaker,
-- and CategoryManager completely on their own, as stand-alone classes.

-- Please anjoy the examples, and hopefully PhysicsLab+ can help turbo-boost your
-- own 2D physics projects!

function setup()
    
    -- test classes
    -- to add your own, copy and paste an existing test into a new tab and modify it from there
    
    tests = {Test_BasicBodies(), Test_BasicJoints(), Test_Gravity(), Test_Sensors(), Test_Categories(), Test_Motors(), Test_Intersections(), Test_EdgesAndChains(), Test_TouchMap(), Test_RotatePushAndPull(), Bonus_EditablePolygon()}
    currentTestIndex = 1
    currentTest = nil
    setTest(currentTestIndex)    
    setDefaultParameters()
end

function setDefaultParameters()
    parameter.clear()
    parameter.integer("TestNumber", 1, #tests)    
    parameter.boolean("UseAccelerometer")
end

function setTest(t)
    if currentTest then
        if currentTest.hasCustomControls then
            setDefaultParameters()
        end
        if currentTest.cleanup then
            currentTest:cleanup()
        end
        cleanup()
    end
    
    currentTestIndex = t
    currentTest = tests[t]
    currentTest:setup()
    for _, body in ipairs(currentTest.lab.bodies) do
        if body.name == "petrieDish" then
            dish = body
        end
    end
end

function nextTest()
    local t = currentTestIndex + 1
    if t > #tests then
        t = 1
    end
    setTest(t)
end

function cleanup()
    output.clear()
end

function draw()
    if UseAccelerometer == true then
        physics.gravity(Gravity)
    else
        physics.gravity(currentTest.lab.defaultGravity)
    end
    
    background(0, 0, 0)
    
    if TestNumber ~= currentTestIndex then
        setTest(TestNumber)
    end
    
    if currentTest and currentTest.draw then currentTest:draw() end
    
    local str = string.format("Test %d - %s", currentTestIndex, currentTest.title)
    
    font("Vegur-Bold")
    fontSize(22)
    fill(255, 255, 255, 255)
    
    local _, sizeH = textSize(str)
    text(str, WIDTH/2, HEIGHT - layout.safeArea.top - 18 - (sizeH * 1.7))
    textWrapWidth(WIDTH-20)
    
end

function touched(touch)
    if currentTest and currentTest.touched then currentTest:touched(touch) end
end

function collide(contact)
    if currentTest and currentTest.collide then
        currentTest:collide(contact)
    end
end